Attribute VB_Name = "EditorModule"
Option Explicit

' ---------------------------------------------------------------
'  This procedure saves an AddFlow diagram in a sequential file.
'  It saves:
' - the control version number
' - the nodes count
' - the links count
' - every properties of each node (except Picture property)
' - every properties of each link.
'
'  Picture property is not saved but you may instead manage
' a correspondance between node and pictures. For
' instance when you load your file, your VB application knows
' that node of type 1 have one icon, nodes of type 2 have another
' icon, etc...
'
'  This program is just an example to show how an AddFlow diagram
' may be saved to disk.
'  Properties that applied to the whole diagram like xGrid are
' not saved here.
'  You may proceed differently: for instance, use a binary or
' a random file and save only the properties you need for your
' application, or use distinct types for node and link.
'  You may consider this program as a starting point to write
' your AddFlow saving/loading procedures adapted to your needs.
'
' THE CODE PROVIDED HEREUNDER IS PROVIDED AS IS WITHOUT WARRANTY
' OF ANY KIND.
' ---------------------------------------------------------------
'

' Following type is used for loading only.

Type ItemRec
  Tag As String
  Text As String
  UserData As Long
  FillColor As Long
  ForeColor As Long
  DrawColor As Long
  DrawWidth As Single
  DrawStyle As Integer
  Shape As Integer
  LinkStyle As Integer
  ArrowOrg As Integer
  ArrowDst As Integer
  Alignment As Integer
  AutoSize As Integer
  Selectable As Boolean
  Marked As Boolean
  Hidden As Boolean
  Rigid As Boolean
  Transparent As Boolean
  Left As Single
  Top As Single
  Width As Single
  Height As Single
  SrcNode As Long
  DstNode As Long
  Points As Integer
  FontName As String
  FontSize As Single
  FontBold As Boolean
  FontItalic As Boolean
  FontUnderline As Boolean
  FontStrikethru As Boolean
End Type

Sub SaveAddFlowFile(AddFlow1 As Control, Filename$)
  Dim i&, length&, LinkCount&, owner&, Org&, Dst&
  Dim s$, CR$
  Dim link As afLink, node As afNode, pt As afLinkPoint
  Dim major%, minor%
  Dim f As Font

  CR = Chr$(13)

  With AddFlow1
    Open Filename For Output As 1
  
    ' Version number
    .GetVersion major, minor
    Print #1, "ADDFLOW VERSION = " + Format$(major) + "." + Format$(minor)

    ' Node count
    Print #1, "Nodes = " + Format$(.Nodes.Count)
    
    ' Link count
    LinkCount = 0
    For Each node In .Nodes
      LinkCount = LinkCount + node.OutLinks.Count
    Next
    Print #1, "Links = " + Format$(LinkCount)

    '-----------
    ' Save nodes
    '-----------

    ' For each node:
    '   - make it the current one
    '   - save its properties in the file

    i = 1
    For Each node In .Nodes
      ' Save current node properties
      Print #1, "Begin Node " + Format$(i)
      Print #1, "  ForeColor = " + Str(node.ForeColor)
      Print #1, "  FillColor = " + Str(node.FillColor)
      Print #1, "  DrawColor = " + Str(node.DrawColor)
      Print #1, "  DrawWidth = " + Str(node.DrawWidth)
      Print #1, "  DrawStyle = " + Str(node.DrawStyle)
      Print #1, "  Alignment = " + Str(node.Alignment)
      Print #1, "  AutoSize = " + Str(node.AutoSize)
      Print #1, "  Shape = " + Str(node.Shape)
      Print #1, "  Left = " + Str(node.Left)
      Print #1, "  Top = " + Str(node.Top)
      Print #1, "  Width = " + Str(node.Width)
      Print #1, "  Height = " + Str(node.Height)
      If node.Transparent = False Then
        Print #1, "  Transparent = " + "0"
      Else
        Print #1, "  Transparent = " + "-1"
      End If
      If node.Selectable = False Then
        Print #1, "  Selectable = " + "0"
      Else
        Print #1, "  Selectable = " + "-1"
      End If
      If node.Marked = False Then
        Print #1, "  Marked = " + "0"
      Else
        Print #1, "  Marked = " + "-1"
      End If
      If node.Hidden = False Then
        Print #1, "  Hidden = " + "0"
      Else
        Print #1, "  Hidden = " + "-1"
      End If
      Print #1, "  UserData = " + Str(node.UserData)
      
      ' Text
      If Len(node.Text) > 0 Then
        s = node.Text
        length = InStr(s, CR)
        While length > 0
          Print #1, "  Text =" + Left$(s, length - 1)
          s = Mid$(s, length + 2)
          length = InStr(s, CR)
        Wend
        Print #1, "  Text =" + s
      End If
      
      ' Tag
      If Len(node.Tag) > 0 Then
        s = node.Tag
        length = InStr(s, CR)
        While length > 0
          Print #1, "  Tag =" + Left$(s, length - 1)
          s = Mid$(s, length + 2)
          length = InStr(s, CR)
        Wend
        Print #1, "  Tag =" + s
      End If
      
      Set f = node.Font
      SaveFont f

      Print #1, "End"
      
      i = i + 1
    Next

    '-----------
    ' Save links
    '-----------
  
    ' For each link, save its properties in the file

    i = 1
    For Each node In .Nodes
     For Each link In node.OutLinks
      ' Find origin and destination
      Org = link.Org.Index
      Dst = link.Dst.Index
    
      ' Save current link properties
      Print #1, "Begin Link " + Format$(i)
      Print #1, "  ForeColor = " + Str(link.ForeColor)
      Print #1, "  DrawColor = " + Str(link.DrawColor)
      Print #1, "  DrawWidth = " + Str(link.DrawWidth)
      Print #1, "  DrawStyle = " + Str(link.DrawStyle)
      Print #1, "  LinkStyle = " + Str(link.LinkStyle)
      Print #1, "  ArrowOrg = " + Str(link.ArrowOrg)
      Print #1, "  ArrowDst = " + Str(link.ArrowDst)
      Print #1, "  Src = " + Format$(Org)
      Print #1, "  Dst = " + Format$(Dst)
      If link.Selectable = False Then
        Print #1, "  Selectable = " + "0"
      Else
        Print #1, "  Selectable = " + "-1"
      End If
      If link.Marked = False Then
        Print #1, "  Marked = " + "0"
      Else
        Print #1, "  Marked = " + "-1"
      End If
      If link.Hidden = False Then
        Print #1, "  Hidden = " + "0"
      Else
        Print #1, "  Hidden = " + "-1"
      End If
      If link.Rigid = False Then
        Print #1, "  Rigid = " + "0"
      Else
        Print #1, "  Rigid = " + "-1"
      End If
    
      ' Extra points
      Print #1, "  Points = " + Format$(link.ExtraPoints.Count)
      For Each pt In link.ExtraPoints
        Print #1, "    " + Format$(pt.X) + "," + Format$(pt.Y)
      Next
      
      Print #1, "  UserData = " + Str(link.UserData)
      
      ' Text
      If Len(link.Text) > 0 Then
        s = link.Text
        length = InStr(s, CR)
        While length > 0
          Print #1, "  Text =" + Left$(s, length - 1)
          s = Mid$(s, length + 2)
          length = InStr(s, CR)
        Wend
        Print #1, "  Text =" + s
      End If
      
      ' Tag
      If Len(link.Tag) > 0 Then
        s = link.Tag
        length = InStr(s, CR)
        While length > 0
          Print #1, "  Tag =" + Left$(s, length - 1)
          s = Mid$(s, length + 2)
          length = InStr(s, CR)
        Wend
        Print #1, "  Tag =" + s
      End If
            
      Set f = link.Font
      SaveFont f

      Print #1, "End"
      
      i = i + 1
     Next
    Next
    
    ' Close file
    Close
  End With
End Sub


Sub OpenAddFlowFile(AddFlow1 As Control, Filename$)
  Dim s$, value$, keyword$, CRLF$
  Dim StoredVersionNumber$, CurrentVersionNumber$
  Dim length%, i%, NodeCount%, LinkCount%, Version%, major%, minor%
  Dim ir As ItemRec
  Dim l&
  Dim ptx() As Long, pty() As Long
  Dim f As New StdFont
  Dim node As afNode, link As afLink, pt As New afLinkPoint

  CRLF = Chr$(13) + Chr$(10)
  Open Filename For Input As #1
  
  With AddFlow1
    Line Input #1, s  ' Version
    StoredVersionNumber = LTrim$(Mid$(s, InStr(s, "=") + 1))
    .GetVersion major, minor
    CurrentVersionNumber = Format$(major) + "." + Format$(minor)

    If CurrentVersionNumber <> StoredVersionNumber Then
      MsgBox "File created by another AddFlow version!", 0, "Editor"
      'Exit Sub
    End If

    ' Node count
    Line Input #1, s
    NodeCount = Val(Mid$(s, InStr(s, "=") + 1))

    ' Link count
    Line Input #1, s
    LinkCount = Val(Mid$(s, InStr(s, "=") + 1))

    If NodeCount = 0 Then
      Close
      Exit Sub
    End If
  
    ReDim owner(1 To NodeCount)

    ' Load all nodes
    For i = 1 To NodeCount
      Line Input #1, s  ' Skip Begin keyword
      length = InStr(s, " ")
      keyword = Left$(s, length - 1)
    
      If keyword = "Begin" Then
        ' Default values
        ir.UserData = 0
        ir.Tag = ""
        ir.Text = ""
        ir.ForeColor = .ForeColor
        ir.FillColor = .FillColor
        ir.DrawColor = .DrawColor
        ir.DrawWidth = .DrawWidth
        ir.DrawStyle = .DrawStyle
        ir.Selectable = True
        ir.Marked = False
        ir.Hidden = .Hidden
        ir.Shape = .Shape
        ir.Alignment = .Alignment
        ir.AutoSize = .AutoSize
        ir.Transparent = .Transparent
        ir.Left = 0
        ir.Top = 0
        ir.Width = 0
        ir.Height = 0
          
        Set f = .Font
        ir.FontName = f.Name
        ir.FontSize = f.Size
        ir.FontBold = f.Bold
        ir.FontItalic = f.Italic
        ir.FontUnderline = f.Underline
        ir.FontStrikethru = f.Strikethrough

        Do
          Line Input #1, s  ' Skip Begin keyword
          s = LTrim$(s)
          length = InStr(s, " ")
          If length > 0 Then
            keyword = Left$(s, length - 1)
          Else
            keyword = s
          End If
          If keyword = "End" Then
            Exit Do
          End If
          value = Mid$(s, length + 2)

          ' Load each node property
          Select Case keyword
          Case "FillColor"
            ir.FillColor = Val(value)
          Case "ForeColor"
            ir.ForeColor = Val(value)
          Case "DrawColor"
            ir.DrawColor = Val(value)
          Case "DrawWidth"
            ir.DrawWidth = Val(value)
          Case "DrawStyle"
            ir.DrawStyle = Val(value)
          Case "Marked"
            ir.Marked = Val(value)
          Case "Selectable"
            ir.Selectable = Val(value)
          Case "Hidden"
            ir.Hidden = Val(value)
          Case "Transparent"
            ir.Transparent = Val(value)
          Case "Alignment"
            ir.Alignment = Val(value)
          Case "AutoSize"
            ir.AutoSize = Val(value)
          Case "Shape"
            ir.Shape = Val(value)
          Case "Left"
            ir.Left = Val(value)
          Case "Top"
            ir.Top = Val(value)
          Case "Width"
            ir.Width = Val(value)
          Case "Height"
            ir.Height = Val(value)
          Case "UserData"
            ir.UserData = Val(value)
          Case "Tag"
            If ir.Tag = "" Then
              ir.Tag = value
            Else
              ir.Tag = ir.Tag + CRLF + value
            End If
          Case "Text"
            If ir.Text = "" Then
              ir.Text = value
            Else
              ir.Text = ir.Text + CRLF + value
            End If
          Case "FontName"
            ir.FontName = value
          Case "FontSize"
            ir.FontSize = Val(value)
          Case "FontBold"
            ir.FontBold = Val(value)
          Case "FontItalic"
            ir.FontItalic = Val(value)
          Case "FontUnderline"
            ir.FontUnderline = Val(value)
          Case "FontStrikethru"
            ir.FontStrikethru = Val(value)
          End Select
        Loop

        ' Create Node
        Set node = .Nodes.Add(ir.Left, ir.Top, ir.Width, ir.Height)

        node.FillColor = ir.FillColor
        node.ForeColor = ir.ForeColor
        node.DrawColor = ir.DrawColor
        node.DrawWidth = ir.DrawWidth
        node.DrawStyle = ir.DrawStyle
        node.Hidden = ir.Hidden
        node.Alignment = ir.Alignment
        node.AutoSize = ir.AutoSize
        node.Shape = ir.Shape
        node.Marked = ir.Marked
        node.Transparent = ir.Transparent
        node.UserData = ir.UserData
        node.Tag = ir.Tag
        node.Text = ir.Text
        
        f.Name = LTrim$(ir.FontName)
        f.Size = ir.FontSize
        f.Bold = ir.FontBold
        f.Italic = ir.FontItalic
        f.Underline = ir.FontUnderline
        f.Strikethrough = ir.FontStrikethru
        Set node.Font = f

        node.Selectable = ir.Selectable
      End If
    Next i

    ' List of link
    For i = 1 To LinkCount
      Line Input #1, s  ' Skip Begin keyword
      length = InStr(s, " ")
      keyword = Left$(s, length - 1)
    
      If keyword = "Begin" Then
        ' Default values
        ir.UserData = 0
        ir.Tag = ""
        ir.Text = ""
        ir.ForeColor = .ForeColor
        ir.DrawColor = .DrawColor
        ir.DrawWidth = .DrawWidth
        ir.DrawStyle = .DrawStyle
        ir.LinkStyle = .LinkStyle
        ir.Selectable = True
        ir.Marked = False
        ir.Hidden = .Hidden
        ir.Rigid = False
        ir.ArrowOrg = .ArrowOrg
        ir.ArrowDst = .ArrowDst
        ir.SrcNode = 0
        ir.DstNode = 0
        ir.Points = 0
        Set f = .Font
        ir.FontName = f.Name
        ir.FontSize = f.Size
        ir.FontBold = f.Bold
        ir.FontItalic = f.Italic
        ir.FontUnderline = f.Underline
        ir.FontStrikethru = f.Strikethrough
  
        Do
          Line Input #1, s  ' Skip Begin keyword
          s = LTrim$(s)
          length = InStr(s, " ")
          If length > 0 Then
            keyword = Left$(s, length - 1)
          Else
            keyword = s
          End If
          If keyword = "End" Then
            Exit Do
          End If
          value = Mid$(s, length + 2)

          ' Load each link property
          Select Case keyword
          Case "ForeColor"
            ir.ForeColor = Val(value)
          Case "DrawColor"
            ir.DrawColor = Val(value)
          Case "DrawWidth"
            ir.DrawWidth = Val(value)
          Case "DrawStyle"
            ir.DrawStyle = Val(value)
          Case "LinkStyle"
            ir.LinkStyle = Val(value)
          Case "Marked"
            ir.Marked = Val(value)
          Case "Selectable"
            ir.Selectable = Val(value)
          Case "Rigid"
            ir.Rigid = Val(value)
          Case "Hidden"
            ir.Hidden = Val(value)
          Case "ArrowOrg"
            ir.ArrowOrg = Val(value)
          Case "ArrowDst"
            ir.ArrowDst = Val(value)
          Case "UserData"
            ir.UserData = Val(value)
          Case "Tag"
            If ir.Tag = "" Then
              ir.Tag = value
            Else
              ir.Tag = ir.Tag + CRLF + value
            End If
          Case "Text"
            If ir.Text = "" Then
              ir.Text = value
            Else
              ir.Text = ir.Text + CRLF + value
            End If
          Case "Src"
            ir.SrcNode = Val(value)
          Case "Dst"
            ir.DstNode = Val(value)
          Case "Points"
            ir.Points = Val(value)

            ' Get points
            If ir.Points > 0 Then
              ReDim ptx(1 To ir.Points)
              ReDim pty(1 To ir.Points)
              For l = 1 To ir.Points
                Line Input #1, s  ' Read point
                s = LTrim$(s)
                length = InStr(s, ",")
                ptx(l) = Val(Left$(s, length - 1))
                pty(l) = Val(Mid$(s, length + 1))
              Next l
            End If
          Case "FontName"
            ir.FontName = value
          Case "FontSize"
            ir.FontSize = Val(value)
          Case "FontBold"
            ir.FontBold = Val(value)
          Case "FontItalic"
            ir.FontItalic = Val(value)
          Case "FontUnderline"
            ir.FontUnderline = Val(value)
          Case "FontStrikethru"
            ir.FontStrikethru = Val(value)
          End Select
        Loop

        ' Create Link
        Set link = .Nodes(ir.SrcNode).OutLinks.Add(.Nodes(ir.DstNode))

        link.ForeColor = ir.ForeColor
        link.DrawColor = ir.DrawColor
        link.DrawWidth = ir.DrawWidth
        link.DrawStyle = ir.DrawStyle
        link.LinkStyle = ir.LinkStyle
        link.Marked = ir.Marked
        link.Hidden = ir.Hidden
        link.Rigid = ir.Rigid
        link.ArrowOrg = ir.ArrowOrg
        link.ArrowDst = ir.ArrowDst
        link.UserData = ir.UserData
        link.Tag = ir.Tag
        link.Text = ir.Text
        For l = 1 To ir.Points
          pt.X = ptx(l)
          pt.Y = pty(l)
          link.ExtraPoints.Add pt
        Next
        
        f.Name = LTrim$(ir.FontName)
        f.Size = ir.FontSize
        f.Bold = ir.FontBold
        f.Italic = ir.FontItalic
        f.Underline = ir.FontUnderline
        f.Strikethrough = ir.FontStrikethru
        Set link.Font = f

        link.Selectable = ir.Selectable
      End If
    Next i
  End With
  
  ' Erase dynamic arrays
  Erase ptx
  Erase pty

  ' Close file
  Close
End Sub





Sub SaveFont(f As Font)
  Print #1, "  FontName = " + f.Name
  Print #1, "  FontSize = " + Str(f.Size)
  If f.Bold = False Then
    Print #1, "  FontBold = " + "0"
  Else
    Print #1, "  FontBold = " + "-1"
  End If
  If f.Italic = False Then
    Print #1, "  FontItalic = " + "0"
  Else
    Print #1, "  FontItalic = " + "-1"
  End If
  If f.Underline = False Then
    Print #1, "  FontUnderline = " + "0"
  Else
    Print #1, "  FontUnderline = " + "-1"
  End If
  If f.Strikethrough = False Then
    Print #1, "  FontStrikethru = " + "0"
  Else
    Print #1, "  FontStrikethru = " + "-1"
  End If
End Sub


